
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.*;

/**
 *
 * @author aNNiMON
 */
public class Canv extends Canvas {
    
    private int w,h;
    private int rx,ry; // поворот модели
    private int scale; // увеличение
    private boolean light; // свет
    
    public Canv() {
        setFullScreenMode(true);
        w=getWidth();
        h=getHeight();
        rx=0; ry=0;
        scale = 4096;
        light = false;
        getModelData();
        Lib_mcv3.init();
    }

    protected void paint(Graphics g) {
        setFullScreenMode(true);
        g.setColor(0x00);
        g.fillRect(0, 0, w, h);
        Lib_mcv3.setFLCenter(w/2, h/2);
        Lib_mcv3.setScaleMDL(scale, scale, scale);
        Lib_mcv3.setRotationMDL(rx, ry);
        Lib_mcv3.drawModel(g);
    }
    
    public void keyPressed(int key) {
        int ga=getGameAction(key);
        repaint();
        if(ga==LEFT) ry-=20;
        if(ga==RIGHT) ry+=20;
        if(ga==UP) rx-=20;
        if(ga==DOWN) rx+=20;
        if(ga==FIRE) {
            light=!light; Lib_mcv3.setLight(light);
        }
        switch(key) {
            case KEY_NUM1: scale-=196; break;
            case KEY_NUM3: scale+=196; break;
            case KEY_NUM0:  Lib_mcv3.nextFrame();
        }
    }
    
    public void keyRepeated(int key) {
        keyPressed(key);
    }

    private void getModelData() {
        Lib_mcv3.setMBAC(getBytes("/res/mine.mbac"));
        Lib_mcv3.setMTRA(getBytes("/res/mine.mtra"));
        Lib_mcv3.setBMP(getBytes("/res/ships.bmp"));
    }
    
    private byte[] getBytes(String path) {
        InputStream is;
        byte[] ab = null;
        try {
            is = getClass().getResourceAsStream(path);
            int i = is.available();
            ab=new byte[i];
            is.read(ab, 0, i);
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return reverse(ab);
    }
    
    private byte[] reverse(byte[] ab) {
        int i = ab.length;
        int j;
        if(i < 100)
            j = 10 + i % 10;
        else
        if(i < 200)
            j = 50 + i % 20;
        else
        if(i < 300)
            j = 80 + i % 20;
        else
            j = 100 + i % 50;
        for(int k = 0; k < j; k++)
        {
            byte byte0 = ab[k];
            ab[k] = ab[i - k - 1];
            ab[i - k - 1] = byte0;
        }
        return ab;
    }

}
