import com.mascotcapsule.micro3d.v3.*;
import javax.microedition.lcdui.*;

/**
 *
 * @author aNNiMON
 */
public class Lib_mcv3 {

    private static Graphics3D g3 = null;
    private static Figure figure;
    private static Texture mainTexture;
    private static Effect3D effect;
    private static AffineTrans viewTrans, modelTrans, tempTrans;
    private static ActionTable action;
    //Свет
    private static Light light;
    private static Vector3D lightdir = new Vector3D(-3511, 731, 878); // Позиция источника света
    private static int dirIntensity = 4096; // Интенсивность света
    private static int ambIntensity = 2048; // Интенсивность амбиент света
    private static boolean lightEnabled; // использовать ли свет?
    
    private static FigureLayout layout;
    private static int centerX, centerY;// центр вывода
    private static boolean persEnabled; //использовать перспективу?
    private static int persNear = 1;
    private static int persFar = 4096;
    private static int persAngle = 682;
    
    private static int spinx = 0;
    private static int spiny = 0;
    
    private static int scalex = 4096;
    private static int scaley = 4096;
    private static int scalez = 4096;
    
    private static int modelx = 0;
    private static int modely = 0;
    private static int modelz = 0;
    
    private static Vector3D Pos = new Vector3D(0, 120, 500);
    private static Vector3D Look = new Vector3D(0, 0, -2000);
    private static Vector3D Up = new Vector3D(0, 4096, 0);
    
    private static boolean Bmtra = false,  hastexdat = false;
    
    private static int frame = 0;
    private static byte[] mbac, mtra, texdata;
    
    /*
     * Загрузка
     * */
    //Модель
    public static void setMBAC(byte[] mbac_b) {
        mbac=mbac_b;
    }
    //Анимация
    public static void setMTRA(byte[] mtra_b) {
        mtra=mtra_b;
        Bmtra=true;
    }
    //Текстура
    public static void setBMP(byte[] texdata_b) {
        texdata=texdata_b;
        hastexdat=true;
    }
    /*
     * Свет
     * */
    // Позиция источника света
    public static void setLightPos(int x, int y, int z) {
        lightdir = new Vector3D(x, y, z);
    }
    //Интенсивность света
    public static void setLightIntensity(int value) {
        dirIntensity=value;
    }
    //Интенсивность амбиент света
    public static void setAmbLightIntensity(int value) {
        ambIntensity=value;
    }
    public static void setLight(boolean light) {
        lightEnabled=light;
    }
    
    /*
     * FigureLayout
     * */
    //центр FL
    public static void setFLCenter(int cx, int cy) {
        centerX=cx;
        centerY=cy;
    }
    //Использовать ли перспективу
    public static void setPerspective(boolean pers) {
        persEnabled=pers;
    }
    // Параметры перспективы
    public static void setPersPos(int near, int far, int angle) {
        persNear = near; //коэфициент ближнего угла
        persFar = far; // дальнего угла
        persAngle = angle; // сам угол
    }
    // Параметры поворота модели
    public static void setRotationMDL(int x, int y) {
        spinx=x;
        spiny=y;
    }
    // Параметры увеличения модели
    public static void setScaleMDL(int x, int y, int z) {
        scalex=x;
        scaley=y;
        scalez=z;
    }
    // Параметры трансформирования модели
    public static void setTransMDL(int x, int y, int z) {
        modelx=x;
        modely=y;
        modelz=z;
    }
    
    /*
     * Анимация
     * */
    //Получить кол-во кадров анимации
    public static void nextFrame() {
        frame += action.getNumFrames(0) / 10;
        if (frame >= action.getNumFrames(0)) {
            frame = 0;
        }
    }
    
    // Позиция камеры
    public static void setViewPos(int x, int y, int z) {
        Pos = new Vector3D(x, y, z);
    }
    // Позиция источника света
    public static void setViewLook(int x, int y, int z) {
        Look = new Vector3D(x, y, z);
    }
    // Позиция источника света
    public static void setViewUp(int x, int y, int z) {
        Up = new Vector3D(x, y, z);
    }
    
    
    public static void init() {
        if (mtra != null) Bmtra = true;
        else Bmtra = false;
        if (texdata != null) hastexdat = true;
        else hastexdat = false;
        g3 = new Graphics3D();
        figure = new Figure(mbac);
        if (hastexdat) {
            mainTexture = new Texture(texdata, true);
            figure.setTexture(mainTexture);
        }
        effect = new Effect3D(null, Effect3D.NORMAL_SHADING, true, null);
        layout = new FigureLayout();
        viewTrans = new AffineTrans();
        modelTrans = new AffineTrans();
        tempTrans = new AffineTrans();
        light = new Light(lightdir, dirIntensity, ambIntensity);
        if (Bmtra) {
            action = new ActionTable(mtra);
        }
    }
    
    /*
     * Отрисовка модели
     * */
    public static void drawModel(Graphics g) {
            //3D рендеринг
            g3.bind(g);
            viewTrans.lookAt(Pos, Look, Up);
            modelTrans.setIdentity();
            if (lightEnabled) effect.setLight(light);
            else effect.setLight(null);
            layout.setCenter(centerX, centerY);
            if (persEnabled) {
                layout.setPerspective(persNear, persFar, persAngle);
            } else {
                layout.setParallelSize(800, 800);
            }
            modelTrans.rotationX(spinx);
            tempTrans.setIdentity();
            tempTrans.rotationY(spiny);
            modelTrans.mul(tempTrans);
            tempTrans.set(scalex, 0, 0, 0, 0, scaley, 0, 0, 0, 0, scalez, 0);
            modelTrans.mul(tempTrans);
            modelTrans.m03 = modelx;
            modelTrans.m13 = modely;
            modelTrans.m23 = modelz;
            viewTrans.mul(modelTrans);
            layout.setAffineTrans(viewTrans);
            if (Bmtra) {
                figure.setPosture(action, 0, frame);
            }
            g3.renderFigure(figure, 0, 0, layout, effect);
            g3.flush();
            g3.release(g);
    }
}
