import javax.microedition.lcdui.*;
import java.io.IOException;
import java.io.DataInputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class Lib_netutils {
   
    /////////////////////////////////////////////////////////////////
    // MIME Types
    /////////////////////////////////////////////////////////////////
    public static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMETYPE_TEXT_XML = "text/xml";
    public static final String MIMETYPE_APP_XML = "application/xml";
    public static final String MIMETYPE_IMAGE_PNG = "image/png";

    /////////////////////////////////////////////////////////////////
    // HTTP Contants
    /////////////////////////////////////////////////////////////////
    private static final String HTTPHDR_ACCEPT = "Accept";

    private static final String HTTPHDR_USER_AGENT = "User-Agent";
    private static String HTTPHDR_USER_AGENT_VALUE;
    
    private static final String HTTPHDR_CONNECTION = "Connection";
    private static final String HTTPHDR_CONNECTION_CLOSE = "close";
            
    private static final String HTTPHDR_CACHE_CONTROL = "Cache-Control";
    private static final String HTTPHDR_CACHE_CONTROL_NOTRANSFORM = 
            "no-transform";
    private static final String HTTPHDR_CONTENT_LEN = "Content-Length";
    
    static {
        // Retrieve the underlying profile and configuration for User Agent
        String p = System.getProperty("microedition.profiles");
        String c = System.getProperty("microedition.configuration");
        HTTPHDR_USER_AGENT_VALUE = "Profile/" + p + " Configuration/" + c;        
    }
        
    /**
     * Gets a Resource over HTTP, returing an <code>DataInputStream</code> to it
     *
     * @param uri is the URI to use to get the resource to retrieve
     * @pararm mimeType is the (possible) mime type(s) of the resource to retrieve
     *
     * @return an <code>DataInputStream</code> for the input resource
     *
     * @throws <code>IOException</code> is thrown if an error is encountered
     */
    private static DataInputStream get_resource_over_http(
            String uri, 
            String mimeType) throws IOException {

        HttpConnection connection = null;
        IOException ioException = null;
        DataInputStream is = null;

        try {
            connection = (HttpConnection) Connector.open(uri, Connector.READ, true);

            connection.setRequestMethod(HttpConnection.GET);

            connection.setRequestProperty(
                    HTTPHDR_ACCEPT, 
                    mimeType);

            connection.setRequestProperty(
                    HTTPHDR_USER_AGENT, 
                    HTTPHDR_USER_AGENT_VALUE);

            connection.setRequestProperty(
                    HTTPHDR_CONNECTION, 
                    HTTPHDR_CONNECTION_CLOSE);

            connection.setRequestProperty(
                    HTTPHDR_CACHE_CONTROL, 
                    HTTPHDR_CACHE_CONTROL_NOTRANSFORM);

            connection.setRequestProperty(
                    HTTPHDR_CONTENT_LEN, 
                    String.valueOf("0"));

            //////////////////////////////////////
            // Send GET, receive initial response
            //////////////////////////////////////
            int rc = connection.getResponseCode();

            /////////////////////////////////////////////////////////
            // If an HTTP error was encountered, stop, indicate error
            /////////////////////////////////////////////////////////
            if (rc != HttpConnection.HTTP_OK) {
                // Log error, throw IO exception
                ioException = new IOException("Http Error, response Code is " + rc);
                throw ioException;
            }
            is = connection.openDataInputStream();
        } catch (IOException ioe) {
            // Log error, throw IO exception
            throw ioe; // Propagate the IO Exception
        } finally {
            if (connection != null) connection.close();
            return is;
        }
    }

    private static Image im = null;

    public static Image get_png(String url){
	DataInputStream is = null;
        try {
            is = get_resource_over_http(url, MIMETYPE_IMAGE_PNG);
	    if(is != null){
	      im = Image.createImage(is);
	      is.close();	
	    }
	    return im;
        } catch (IOException ioe) {
            // Log error, exit
            return null;
	}
    }
}
